require("scripts/maps/map_helpers.lua");
SetMapBackground("map/map_background_2");

MakeDialog
{
	Window
	{
		x = 0, y = 0, w = kMax, h = kMax,
		
		MakeRestaurantButtons('waterpark', 525, 300, 400, 300);
		MakeRestaurantButtons('halloween', 150, 40, 50, 50);
		MakeRestaurantButtons('harvest', 500, 15, 390, 10);
		
		SetStyle(DefaultStyle);
		
		MovingWindow
		{
			name="maplefttray",
			x=0,y=274,
			dirX = -5,
			dirY = 0,
			startoff = 1,
			onDelay = 500,
			
			Bitmap
			{
				image = "map/map_tray",
				x = 0,
				y = 0,
				
				Text
				{
					x = 0, y = 95,
					w = kMax-20, h = kMax,
					flags = kHAlignCenter + kVAlignTop,
					name = 'mapleftlabel',
					label = 'map_2_left',
					font = MapArrowFont,
				}
			};
			
			Button
			{
				x=15,
				y=22,
				name="mapleft",
				graphics=NextMapGraphics,
				label="",
				command=
					function()
						SwitchMapPage('1');
						SetupCurrentMapPage();
					end
				
			},
			
		};
		
		Text
		{	
			name = 'mydinerlabel',
			label = 'map_mydiner',
			font = MyDinerFont,
			x = 17, y = 179,
			w = 80, h = 18,
			flags = kHAlignCenter + kVAlignCenter
		};
			

		
	},
	
	
};
EnableWindow('mydiner_rollover', false);
SlideMovingWindow('maplefttray', true);


HideRestaurantButtons('waterpark');
HideRestaurantButtons('halloween');
HideRestaurantButtons('harvest');
EnableWindow('waterpark_rollover', false);
EnableWindow('halloween_rollover', false);
EnableWindow('harvest_rollover', false);

